#! /usr/bin/env R

# ---------------------------------------------------------
## Default repo
local({r <- getOption("repos")
       r["CRAN"] <- "https://cloud.r-project.org" 
       options(repos=r)
})
# ---------------------------------------------------------


# ---------------------------------------------------------
# easier to install packages
install.packages("devtools")
install.packages("purrr")

library(purrr)
library(devtools)
# ---------------------------------------------------------


# ---------------------------------------------------------
# --- list of necessary packages for running code
l_task_data = list(
  "import", "readxl", "haven", "data.table", "bit64", 
  "lubridate", "magrittr", "glue", "lubridate", "tidyr")

l_task_LR = list(
  "magrittr", "glue", "lubridate", "stringr", "haven", "ggplot2",
  "roll", "data.table", "statar", "zoo", "dplyr", "RcppRoll")

l_task_empirics = list(
  "magrittr", "glue", "lubridate", "stringr", "haven", "ggplot2",
  "data.table", "bit64", "lfe", "zeallot", "stargazer", "texreg",
  "brew", "ggsci", "scales", "gridExtra", "tikzDevice", 
  "patchwork", "devtools", "did")


check_install = function(package_name){
  check_if_installed=require(package_name, , character.only = TRUE)
  if (check_if_installed==FALSE){
    install.packages(package_name)
    return(paste0("installing ... ", package_name) )
  } else {
    return(paste0(package_name, " already installed"))
  }
}

message(paste(
  map_chr(unique(c(l_task_data, l_task_LR, l_task_empirics)), 
          ~ check_install(.x)),
  collapse="\n"))

# --- DiD requires an older version 
devtools::install_version("did", version = "2.0.0", repos = "http://cran.us.r-project.org")
devtools::install_version("did", version = "2.1.1", repos = "http://cran.us.r-project.org")
# ---------------------------------------------------------
